
load('E:\Google Drive\Projects\HI-SCALE SGP\Scripts_moved\ImportedPSAPdata_IOP1_frompsap2folder.mat');

[raintime,precip] = ImportingORGRain;


rainstart = datetime([...
	2016,04,26,23,19,00 ;...
	2016,04,29,18,50,00 ;...
	2016,05,09,04,08,00 ;...
	2016,05,10,00,49,00 ;...
	2016,05,13,22,54,00 ;...
	2016,05,16,15,21,00 ;...
	2016,05,17,04,32,00 ]);

rainend = datetime([...
	2016,04,27,03,27,00 ;...
	2016,04,30,03,30,00 ;...
	2016,05,09,04,30,00 ;...
	2016,05,10,01,32,00 ;...
	2016,05,14,00,33,00 ;...
	2016,05,16,16,34,00 ;...
	2016,05,17,13,12,00 ]);

for q = 1:size(rainend,1)
	
	[~,aaeidx_rainstart(q)] = min(abs(PSAPtime - rainstart(q)));
	[~,aaeidx_rainend(q)] = min(abs(PSAPtime - rainend(q)));
	
	[~,rainstartidx(q)] = min(abs(raintime - rainstart(q)));
	[~,rainendidx(q)] = min(abs(raintime - rainend(q)));
	
	avgaaestart(q,1) = nanmean(RBangstrom(aaeidx_rainstart(q)-10:aaeidx_rainstart(q)));
	
	postrain_avgaae(q,1) = nanmean(RBangstrom(aaeidx_rainend(q):aaeidx_rainend(q)+30));
	postrain_avgaae(q,2) = nanmean(RBangstrom(aaeidx_rainend(q):aaeidx_rainend(q)+60));
	postrain_avgaae(q,3) = nanmean(RBangstrom(aaeidx_rainend(q):aaeidx_rainend(q)+120));
	postrain_avgaae(q,4) = nanmean(RBangstrom(aaeidx_rainend(q):aaeidx_rainend(q)+180));
	
	avgrain(q,1) = nanmean(precip(rainstartidx(q):rainendidx(q)));
	
	
end

aaediff = postrain_avgaae(:,3) - avgaaestart;

aaediff_perc = aaediff .* 100 ./ avgaaestart;